/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
 * Description: sgemm interface for the user
 * Create: 2025-4-8
 * LastEditTime: 2025-4-27
 */

#ifndef CBLAS_H
#define CBLAS_H

#include <stddef.h>
#include <stdint.h>
typedef int8_t BLASINT8;
typedef uint8_t BLASUINT8;

#ifndef BLAS_TYPES_DEF
#define BLAS_TYPES_DEF
typedef long BLASLONG;
typedef unsigned long BLASULONG;
#ifdef USE64BITINT
typedef BLASLONG BLASINT;
#define blasabs(x) labs(x)
#else
typedef int BLASINT;
#define blasabs(x) abs(x)
#endif // USE64BITINT

#endif // BLAS_TYPES_DEF

#ifdef __cplusplus
extern "C" {
/* Assume C declarations for C++ */
#endif /* __cplusplus */

#define CBLAS_INDEX size_t

/* matrix saved in rows or cols */
typedef enum CBLAS_ORDER {
    CblasRowMajor = 101,
    CblasColMajor = 102
} CBLAS_ORDER;

/* matrix transpose or conjugate transpose */
typedef enum CBLAS_TRANSPOSE {
    CblasNoTrans = 111,
    CblasTrans = 112,
    CblasConjTrans = 113, // conjugate transpose
    CblasConjNoTrans = 114
} CBLAS_TRANSPOSE;

/* matrix upper or lower */
typedef enum CBLAS_UPLO {
    CblasUpper = 121,
    CblasLower = 122
} CBLAS_UPLO;

/* matrix diagonal is unit or no unit */
typedef enum CBLAS_DIAG {
    CblasNonUnit = 131,
    CblasUnit = 132
} CBLAS_DIAG;

/* matrix position is left or right */
typedef enum CBLAS_SIDE {
    CblasLeft = 141,
    CblasRight = 142
} CBLAS_SIDE;
typedef CBLAS_ORDER CBLAS_LAYOUT;

typedef enum CBLAS_OFFSET {
    CblasRowOffset = 171,
    CblasColOffset = 172,
    CblasFixOffset = 173
} CBLAS_OFFSET;

void konnx_sgemm(const BLASINT isPacked, const enum CBLAS_ORDER order, const enum CBLAS_TRANSPOSE transA,
    const enum CBLAS_TRANSPOSE transB, const BLASINT m, const BLASINT n, const BLASINT k, const float alpha,
    const float *a, const BLASINT lda, const float *b, const BLASINT ldb, const float beta, float *c,
    const BLASINT ldc);
void konnx_sgemm_itcopy(const BLASLONG m, const BLASLONG n, const float *a, const BLASLONG lda, float *b);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
